import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/route/route.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/core/utils/my_icons.dart';
import 'package:viserpay_agent/core/utils/style.dart';
import 'package:viserpay_agent/data/controller/home/home_controller.dart';
import 'package:viserpay_agent/view/components/image/custom_svg_picture.dart';
import 'package:viserpay_agent/view/components/image/my_image_widget.dart';
import 'package:viserpay_agent/view/screens/bottom_nav_section/home/widget/balance_widget.dart';

class TopSection extends StatefulWidget {
  final GlobalKey<ScaffoldState> bootomNavscaffoldKey;

  const TopSection({super.key, required this.bootomNavscaffoldKey});

  @override
  State<TopSection> createState() => _TopSectionState();
}

class _TopSectionState extends State<TopSection> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<HomeController>(
      builder: (controller) => Container(
        width: MediaQuery.of(context).size.width,
        padding: const EdgeInsets.symmetric(vertical: Dimensions.space20, horizontal: Dimensions.space15),
        decoration: BoxDecoration(color: MyColor.getPrimaryColor()),
        child: Row(
          crossAxisAlignment: CrossAxisAlignment.start,
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                GestureDetector(
                  onTap: () {
                    Get.toNamed(RouteHelper.profileScreen);
                  },
                  child: MyImageWidget(
                    height: 40,
                    width: 40,
                    imageUrl: controller.imagePath,
                    radius: 50,
                  ),
                ),
                const SizedBox(width: Dimensions.space10),
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(controller.username, // dynamic
                        style: regularLarge.copyWith(color: MyColor.colorWhite, fontWeight: FontWeight.w500)),
                    const SizedBox(height: Dimensions.space5),
                    BalanceCard(controller: controller)
                  ],
                )
              ],
            ),
            Row(
              children: [
                const SizedBox(
                  width: Dimensions.space10,
                ),
                GestureDetector(
                  onTap: () {
                    widget.bootomNavscaffoldKey.currentState!.openDrawer();
                  },
                  child: const CustomSvgPicture(
                    image: MyIcons.menuTop,
                    color: MyColor.colorWhite,
                    height: 24,
                  ),
                ),
                const SizedBox(
                  width: Dimensions.space15,
                ),
              ],
            ),
          ],
        ),
      ),
    );
  }
}
